library(lme4)
library(GLMMadaptive)
library(ggeffects)
library(ggrepel)
library(tidyverse)
library(performance)  

###########################################################
#                       ANALYSIS                          #
###########################################################

## table 1
rm(list = ls())
load("~/E1.Rda")


# 1 selection model
E1.a <- E1[complete.cases(E1$armed.forces.log, E1$mission.number.state,
                          E1$selection.lag, E1$g20, E1$gdp.pc.2015.log,
                          E1$state.polity, E1$bi.trade.cur.per, 
                          E1$ideal.point.diff, E1$fatality.mission),]    

selection.a <- mixed_model(fixed = selection ~ armed.forces.log  + mission.number.state + selection.lag + g20 
                         + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + fatality.mission,
                         random = ~ 1|state, 
                         family = binomial ( link = "probit" ),
                         data = E1.a
                         )
summary(selection.a)

# 2 predicting outcome
probit.a = predict(selection.a, newdata = E1.a)
E1.b <- data.frame(E1.a,probit.a)
E1.b$prediction <- 0
E1.b$prediction[E1.b$prediction >= .5] <- 1
E1.b$pred.yes <- 0 # 0: wrong prediction, 1: correct prediction
E1.b$pred.yes[E1.b$prediction == E1.b$selection] <- 1
table(E1.b$pred.yes)  

# 3. find the imr (inverse Mill's ratio)
imr.a = dnorm(qnorm(probit.a))/probit.a
E2.a <- data.frame(E1.a, imr.a)
E2.a<-E2.a[E2.a$selection == 1,] 

# 4. allocation model
E2.b <- E2.a[complete.cases(E2.a$armed.forces.log, E2.a$troops.mean, E2.a$mission.number.state,
                            E2.a$token10.lag, E2.a$g20, E2.a$gdp.pc.2015.log,
                            E2.a$state.polity, E2.a$bi.trade.cur.per, 
                            E2.a$ideal.point.diff, E2.a$noncombatant, E2.a$fatality.mission,  E2.a$imr.a),]    

allocation.a <- mixed_model(fixed = token10 ~ armed.forces.log + troops.mean + mission.number.state + token10.lag + g20
                          + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + noncombatant + fatality.mission + imr.a, 
                          random = ~ 1 |state,
                          family = binomial ( link = "probit" ),
                          data = E2.b,
                          iter_EM = 0
                          )
summary(allocation.a)

# 5 predicting outcome  
probit.b = predict(allocation.a, newdata = E2.b)
E2.b <- data.frame(E2.b,probit.b)
E2.b$prediction <- 0
E2.b$prediction[E2.b$prediction>=.5] <- 1
E2.b$pred.yes <- 0 # 0: wrong prediction, 1: correct prediction
E2.b$pred.yes[E2.b$prediction == E2.b$token] <- 1
table(E2.b$pred.yes)  

###########################################################
#                  Online Appendix                        #
###########################################################
# A online appendix 20% threshold 

# A.1 selection model
rm(list=ls())
load("~/Dropbox/UN PKO Project/27 token contribution/data/E1.Rda")

E1.a <- E1[complete.cases(E1$armed.forces.log, E1$mission.number.state,
                          E1$selection.lag, E1$g20, E1$gdp.pc.2015.log,
                          E1$state.polity, E1$bi.trade.cur.per, 
                          E1$ideal.point.diff, E1$fatality.mission), ]    

selection.a <- mixed_model(fixed = selection ~ armed.forces.log  + mission.number.state + selection.lag + g20 
                           + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + fatality.mission,
                           random = ~ 1|state,  
                           family = binomial (link = "probit"),
                           data = E1.a
)
summary(selection.a)


# A.2 predicting outcome
probit.a = predict(selection.a, newdata = E1.a)
E1.b <- data.frame(E1.a,probit.a)
E1.b$prediction <- 0
E1.b$prediction[E1.b$prediction >= .5] <- 1
E1.b$pred.yes <- 0 # 0: wrong prediction, 1: correct prediction
E1.b$pred.yes[E1.b$prediction == E1.b$selection] <- 1
table(E1.b$pred.yes)  

# A.3. find the imr (inverse Mill's ratio)
imr.a = dnorm(qnorm(probit.a)) / probit.a
E2.a <- data.frame(E1.a, imr.a)
E2.a <- E2.a[E2.a$selection == 1,] 

# A.4. allocation model
E2.b <- E2.a[complete.cases(E2.a$armed.forces.log, E2.a$troops.mean, E2.a$mission.number.state,
                            E2.a$token20.lag, E2.a$g20, E2.a$gdp.pc.2015.log,
                            E2.a$state.polity, E2.a$bi.trade.cur.per, 
                            E2.a$ideal.point.diff, E2.a$noncombatant, E2.a$fatality.mission,  E2.a$imr.a),]    

allocation.a <- mixed_model(fixed = token20 ~ armed.forces.log + troops.mean + mission.number.state + token20.lag + g20
                            + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + noncombatant + fatality.mission + imr.a, 
                            random = ~ 1 |state,
                            family = binomial (link = "probit"),
                            data = E2.b,
                            iter_EM = 0
)
summary(allocation.a)

# B online appendix 30% threshold

# B.1 selection model
E1.a <- E1[complete.cases(E1$armed.forces.log, E1$mission.number.state,
                          E1$selection.lag, E1$g20, E1$gdp.pc.2015.log,
                          E1$state.polity, E1$bi.trade.cur.per, 
                          E1$ideal.point.diff, E1$fatality.mission),]    

selection.a <- mixed_model(fixed = selection ~ armed.forces.log  + mission.number.state + selection.lag + g20 
                           + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + fatality.mission,
                           random = ~ 1|state,  
                           family = binomial (link = "probit"),
                           data = E1.a
)
summary(selection.a)

# B.2 predicting outcome
probit.a = predict(selection.a, newdata = E1.a)
E1.b <- data.frame(E1.a,probit.a)
E1.b$prediction <- 0
E1.b$prediction[E1.b$prediction >= .5] <- 1
E1.b$pred.yes <- 0 # 0: wrong prediction, 1: correct prediction
E1.b$pred.yes[E1.b$prediction == E1.b$selection] <- 1
table(E1.b$pred.yes)  

# B.3. find the imr (inverse Mill's ratio)
imr.a = dnorm(qnorm(probit.a))/probit.a
E2.a <- data.frame(E1.a, imr.a)
E2.a <- E2.a[E2.a$selection == 1,] 

# B.4. allocation model
E2.b <- E2.a[complete.cases(E2.a$armed.forces.log, E2.a$troops.mean, E2.a$mission.number.state,
                            E2.a$token30.lag, E2.a$g20, E2.a$gdp.pc.2015.log,
                            E2.a$state.polity, E2.a$bi.trade.cur.per, 
                            E2.a$ideal.point.diff, E2.a$noncombatant, E2.a$fatality.mission,  E2.a$imr.a),]    

allocation.a <- mixed_model(fixed = token30 ~ armed.forces.log + troops.mean + mission.number.state + token30.lag + g20
                            + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + noncombatant + fatality.mission + imr.a, 
                            random = ~ 1 |state,
                            family = binomial (link = "probit"),
                            data = E2.b,
                            iter_EM = 0
)
summary(allocation.a)

# C robust test with fixed threshold 40 and 100

# C.1 selection model
E1.a <- E1[complete.cases(E1$armed.forces.log, E1$mission.number.state,
                          E1$selection.lag, E1$g20, E1$gdp.pc.2015.log,
                          E1$state.polity, E1$bi.trade.cur.per, 
                          E1$ideal.point.diff, E1$fatality.mission),]    

selection.a <- mixed_model(fixed = selection ~ armed.forces.log  + mission.number.state + selection.lag + g20 
                           + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + fatality.mission,
                           random = ~ 1|state,  
                           family = binomial (link = "probit"),
                           data = E1.a
)
summary(selection.a)

# C.2 predicting outcome
probit.a = predict(selection.a, newdata = E1.a)
E1.b <- data.frame(E1.a, probit.a)
E1.b$prediction <- 0
E1.b$prediction[E1.b$prediction >= .5] <- 1
E1.b$pred.yes <- 0 # 0: wrong prediction, 1: correct prediction
E1.b$pred.yes[E1.b$prediction == E1.b$selection] <- 1
table(E1.b$pred.yes)  

# C.3. find the imr (inverse Mill's ratio)
imr.a = dnorm(qnorm(probit.a)) / probit.a
E2.a <- data.frame(E1.a, imr.a)
E2.a <- E2.a[E2.a$selection == 1,] 

# C.4. allocation model with 40 fixed threshold
E2.b <- E2.a[complete.cases(E2.a$armed.forces.log, E2.a$troops.mean, E2.a$mission.number.state,
                            E2.a$token40.lag, E2.a$g20, E2.a$gdp.pc.2015.log,
                            E2.a$state.polity, E2.a$bi.trade.cur.per, 
                            E2.a$ideal.point.diff, E2.a$noncombatant, E2.a$fatality.mission,  E2.a$imr.a),]    

allocation.a <- mixed_model(fixed = token40 ~ armed.forces.log + troops.mean + mission.number.state + token40.lag + g20
                            + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + noncombatant + fatality.mission + imr.a, 
                            random = ~ 1 |state,
                            family = binomial (link = "probit"),
                            data = E2.b,
                            iter_EM = 0
)
summary(allocation.a)

# D.4. allocation model with 100 fixed threshold
E2.b <- E2.a[complete.cases(E2.a$armed.forces.log, E2.a$troops.mean, E2.a$mission.number.state,
                            E2.a$token100.lag, E2.a$g20, E2.a$gdp.pc.2015.log,
                            E2.a$state.polity, E2.a$bi.trade.cur.per, 
                            E2.a$ideal.point.diff, E2.a$noncombatant, E2.a$fatality.mission,  E2.a$imr.a),]    

allocation.a <- mixed_model(fixed = token100 ~ armed.forces.log + troops.mean + mission.number.state + token100.lag + g20
                            + gdp.pc.2015.log + state.polity +  bi.trade.cur.per + ideal.point.diff + noncombatant + fatality.mission + imr.a, 
                            random = ~ 1 |state,
                            family = binomial (link = "probit"),
                            data = E2.b,
                            iter_EM = 0
)
summary(allocation.a)
